// To parse this JSON data, do
//
//     final lavelRewardResponseDataModel = lavelRewardResponseDataModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay/data/model/faq/faq_response_model.dart';
import 'package:viserpay/data/model/global/meassage_model.dart';
import 'package:viserpay/data/model/global/user/user_model.dart';

LevelRewardResponseDataModel levelRewardResponseDataModelFromJson(String str) => LevelRewardResponseDataModel.fromJson(json.decode(str));

String levelRewardResponseDataModelToJson(LevelRewardResponseDataModel data) => json.encode(data.toJson());

class LevelRewardResponseDataModel {
  final String? remark;
  final String? status;
  final Message? message;
  final Data? data;

  LevelRewardResponseDataModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory LevelRewardResponseDataModel.fromJson(Map<String, dynamic> json) => LevelRewardResponseDataModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  final GlobalUser? user;
  final List<EarnedPointModel>? earnedPoints;
  final List<ExpiredPoint>? expiredPoints;
  final List<UserReward>? usedPoints;
  final List<LevelReward>? levelRewards;
  final List<FaqModel>? rewardFaq;
  final List<UserReward>? redeemRewards;

  Data({
    this.user,
    this.earnedPoints,
    this.expiredPoints,
    this.usedPoints,
    this.levelRewards,
    this.rewardFaq,
    this.redeemRewards,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        user: json["user"] == null ? null : GlobalUser.fromJson(json["user"]),
        earnedPoints: json["earned_points"] == null ? [] : List<EarnedPointModel>.from(json["earned_points"]!.map((x) => EarnedPointModel.fromJson(x))),
        expiredPoints: json["expired_points"] == null ? [] : List<ExpiredPoint>.from(json["expired_points"]!.map((x) => ExpiredPoint.fromJson(x))),
        usedPoints: json["used_points"] == null ? [] : List<UserReward>.from(json["used_points"]!.map((x) => UserReward.fromJson(x))),
        levelRewards: json["level_rewards"] == null ? [] : List<LevelReward>.from(json["level_rewards"]!.map((x) => LevelReward.fromJson(x))),
        rewardFaq: json["reward_faq"] == null ? [] : List<FaqModel>.from(json["reward_faq"]!.map((x) => FaqModel.fromJson(x))),
        redeemRewards: json["redeem_rewards"] == null ? [] : List<UserReward>.from(json["redeem_rewards"]!.map((x) => UserReward.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "user": user?.toJson(),
        "earned_points": earnedPoints == null ? [] : List<dynamic>.from(earnedPoints!.map((x) => x.toJson())),
        "expired_points": expiredPoints == null ? [] : List<dynamic>.from(expiredPoints!.map((x) => x.toJson())),
        "used_points": usedPoints == null ? [] : List<dynamic>.from(usedPoints!.map((x) => x)),
        "level_rewards": levelRewards == null ? [] : List<dynamic>.from(levelRewards!.map((x) => x.toJson())),
        "reward_faq": rewardFaq == null ? [] : List<dynamic>.from(rewardFaq!.map((x) => x.toJson())),
        "redeem_rewards": redeemRewards == null ? [] : List<dynamic>.from(redeemRewards!.map((x) => x)),
      };
}

class EarnedPointModel {
  final String? id;
  final String? points;
  final String? userId;
  final String? pointAbleAmount;
  final String? expiresAt;
  final String? remark;
  final String? status;
  final String? createdAt;
  final String? updatedAt;

  EarnedPointModel({
    this.id,
    this.points,
    this.userId,
    this.pointAbleAmount,
    this.expiresAt,
    this.remark,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  factory EarnedPointModel.fromJson(Map<String, dynamic> json) => EarnedPointModel(
        id: json["id"].toString(),
        points: json["points"].toString(),
        userId: json["user_id"].toString(),
        pointAbleAmount: json["pointable_amount"].toString(),
        expiresAt: json["expires_at"] == null ? null : json["expires_at"].toString(),
        remark: json["remark"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"] == null ? null : json["created_at"].toString(),
        updatedAt: json["updated_at"] == null ? null : json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "points": points,
        "user_id": userId,
        "pointable_amount": pointAbleAmount,
        "expires_at": expiresAt,
        "remark": remark,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class ExpiredPoint {
  final String? month;
  final String? totalPoints;

  ExpiredPoint({
    this.month,
    this.totalPoints,
  });

  factory ExpiredPoint.fromJson(Map<String, dynamic> json) => ExpiredPoint(
        month: json["month"].toString(),
        totalPoints: json["total_points"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "month": month,
        "total_points": totalPoints,
      };
}

class LevelReward {
  final String? id;
  final String? name;
  final String? minPoints;
  final String? maxPoints;
  final String? status;
  final String? createdAt;
  final String? updatedAt;
  final List<Reward>? rewards;

  LevelReward({
    this.id,
    this.name,
    this.minPoints,
    this.maxPoints,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.rewards,
  });

  factory LevelReward.fromJson(Map<String, dynamic> json) => LevelReward(
        id: json["id"].toString(),
        name: json["name"].toString(),
        minPoints: json["min_points"].toString(),
        maxPoints: json["max_points"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        rewards: json["rewards"] == null ? [] : List<Reward>.from(json["rewards"]!.map((x) => Reward.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "min_points": minPoints,
        "max_points": maxPoints,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "rewards": rewards == null ? [] : List<dynamic>.from(rewards!.map((x) => x.toJson())),
      };
}

class Reward {
  final String? id;
  final String? levelId;
  final String? requiredPoints;
  final String? name;
  final String? description;
  final String? validityDays;
  final String? rewardTypeId;
  final String? rewardValue;
  final String? rewardValueType;
  final String? minTransactionAmount;
  final String? transactionType;
  final String? status;
  final String? createdAt;
  final String? updatedAt;
  final RewardType? rewardType;

  Reward({
    this.id,
    this.levelId,
    this.requiredPoints,
    this.name,
    this.description,
    this.validityDays,
    this.rewardTypeId,
    this.rewardValue,
    this.rewardValueType,
    this.minTransactionAmount,
    this.transactionType,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.rewardType,
  });

  factory Reward.fromJson(Map<String, dynamic> json) => Reward(
        id: json["id"].toString(),
        levelId: json["level_id"].toString(),
        requiredPoints: json["required_points"].toString(),
        name: json["name"].toString(),
        description: json["description"].toString(),
        validityDays: json["validity_days"].toString(),
        rewardTypeId: json["reward_type_id"].toString(),
        rewardValue: json["reward_value"].toString(),
        rewardValueType: json["reward_value_type"].toString(),
        minTransactionAmount: json["min_transaction_amount"].toString(),
        transactionType: json["transaction_type"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        rewardType: json["reward_type"] == null ? null : RewardType.fromJson(json["reward_type"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "level_id": levelId,
        "required_points": requiredPoints,
        "name": name,
        "description": description,
        "validity_days": validityDays,
        "reward_type_id": rewardTypeId,
        "reward_value": rewardValue,
        "reward_value_type": rewardValueType,
        "min_transaction_amount": minTransactionAmount,
        "transaction_type": transactionType,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "reward_type": rewardType?.toJson(),
      };
}

class RewardType {
  final String? id;
  final String? name;
  final String? remark;
  final String? status;
  final String? createdAt;
  final String? updatedAt;

  RewardType({
    this.id,
    this.name,
    this.remark,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  factory RewardType.fromJson(Map<String, dynamic> json) => RewardType(
        id: json["id"].toString(),
        name: json["name"].toString(),
        remark: json["remark"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "remark": remark,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class UserReward {
  final String? id;
  final String? userId;
  final String? rewardId;
  final String? pointsUsed;
  final String? expiresAt;
  final String? status;
  final String? createdAt;
  final String? updatedAt;
  final Reward? reward;

  UserReward({
    this.id,
    this.userId,
    this.rewardId,
    this.pointsUsed,
    this.expiresAt,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.reward,
  });

  factory UserReward.fromJson(Map<String, dynamic> json) => UserReward(
        id: json["id"].toString(),
        userId: json["user_id"].toString(),
        rewardId: json["reward_id"].toString(),
        pointsUsed: json["points_used"].toString(),
        expiresAt: json["expires_at"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        reward: json["reward"] == null ? null : Reward.fromJson(json["reward"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "reward_id": rewardId,
        "points_used": pointsUsed,
        "expires_at": expiresAt,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "reward": reward?.toJson(),
      };
}
